

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Base de datos: `ventas`
--

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `detalle_venta`
--

CREATE TABLE IF NOT EXISTS `detalle_venta` (
  `cantidad` int(11) DEFAULT NULL,
  `total` int(11) DEFAULT NULL,
  `ventas_codigo_ventas` int(11) NOT NULL,
  `producto_codigo_producto` int(11) NOT NULL
) ENGINE=InnoDB AUTO_INCREMENT=1214 DEFAULT CHARSET=utf8;

--
-- Volcado de datos para la tabla `detalle_venta`
--

INSERT INTO `detalle_venta` (`cantidad`, `total`, `ventas_codigo_ventas`, `producto_codigo_producto`) VALUES
(3, 45000, 1213, 11);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `perfil`
--

CREATE TABLE IF NOT EXISTS `perfil` (
  `codigo_perfil` int(3) NOT NULL,
  `nombre_perfil` set('administrador','consulta','vendedor') DEFAULT NULL
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

--
-- Volcado de datos para la tabla `perfil`
--

INSERT INTO `perfil` (`codigo_perfil`, `nombre_perfil`) VALUES
(1, 'administrador'),
(2, 'consulta'),
(3, 'vendedor');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `producto`
--

CREATE TABLE IF NOT EXISTS `producto` (
  `codigo_producto` int(11) NOT NULL,
  `nombre_producto` varchar(45) DEFAULT NULL,
  `precio_producto` int(11) DEFAULT NULL,
  `tipo_codigo_tipo` int(11) NOT NULL
) ENGINE=InnoDB AUTO_INCREMENT=521223 DEFAULT CHARSET=utf8;

--
-- Volcado de datos para la tabla `producto`
--

INSERT INTO `producto` (`codigo_producto`, `nombre_producto`, `precio_producto`, `tipo_codigo_tipo`) VALUES
(2, 'samsung galaxy s2', 150000, 1),
(3, 'notebook lenovo', 450000, 4),
(4, 'cocina fenza 4 platos', 250000, 6),
(11, 'notebook lenovo', 500000, 4);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `tipo`
--

CREATE TABLE IF NOT EXISTS `tipo` (
  `codigo_tipo` int(11) NOT NULL,
  `nombre_tipo` varchar(25) DEFAULT NULL
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

--
-- Volcado de datos para la tabla `tipo`
--

INSERT INTO `tipo` (`codigo_tipo`, `nombre_tipo`) VALUES
(1, 'tecnologia'),
(2, 'electrohogar'),
(3, 'dormitorio'),
(4, 'muebles'),
(5, 'dormitorio'),
(6, 'infantil'),
(8, 'ropa'),
(9, 'auto'),
(10, 'muebles');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `usuarios`
--

CREATE TABLE IF NOT EXISTS `usuarios` (
  `id_usuario` int(11) NOT NULL,
  `login_usuario` varchar(45) DEFAULT NULL,
  `pass_usuario` varchar(45) DEFAULT NULL,
  `nombre_usuario` varchar(45) DEFAULT NULL,
  `apellido_usuario` varchar(45) DEFAULT NULL,
  `correo_usuario` varchar(45) DEFAULT NULL,
  `fechanacimiento_usuario` date DEFAULT NULL,
  `perfil_codigo_perfil` int(11) NOT NULL
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8;

--
-- Volcado de datos para la tabla `usuarios`
--

INSERT INTO `usuarios` (`id_usuario`, `login_usuario`, `pass_usuario`, `nombre_usuario`, `apellido_usuario`, `correo_usuario`, `fechanacimiento_usuario`, `perfil_codigo_perfil`) VALUES
(39, 'xcode', '202cb962ac59075b964b07152d234b70', 'jose', 'carmona', 'jos.carmona@gmail.com', '2015-01-01', 1),
(40, 'stefa', '202cb962ac59075b964b07152d234b70', 'stefani', 'nunes', 'nunes.estefa@gmail.com', '2015-01-01', 3),
(41, 'basti', '202cb962ac59075b964b07152d234b70', 'bastian', 'alvares', 'basti.bastian@gmail.com', '2015-01-01', 2),
(42, 'admin', '202cb962ac59075b964b07152d234b70', 'jose', 'carmona', 'alejo@gmail.com', '0000-00-00', 3),
(43, 'auto', '202cb962ac59075b964b07152d234b70', 'perro', 'peroo', 'aldalks@gail.odksnv', '2013-01-01', 2),
(44, 'seba', '202cb962ac59075b964b07152d234b70', 'sebastian', 'blanco', 'seba@.com', '2015-01-01', 1),
(45, 'carolina', '202cb962ac59075b964b07152d234b70', 'carolina', 'nunez', 'carola@gmail.com', '2015-07-01', 3);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `ventas`
--

CREATE TABLE IF NOT EXISTS `ventas` (
  `codigo_ventas` int(11) NOT NULL,
  `codigo_vendedor` varchar(45) DEFAULT NULL,
  `fecha_venta` date DEFAULT NULL,
  `total_venta` int(11) DEFAULT NULL,
  `perfil_codigo_perfil` int(11) NOT NULL
) ENGINE=InnoDB AUTO_INCREMENT=1216 DEFAULT CHARSET=utf8;

--
-- Volcado de datos para la tabla `ventas`
--

INSERT INTO `ventas` (`codigo_ventas`, `codigo_vendedor`, `fecha_venta`, `total_venta`, `perfil_codigo_perfil`) VALUES
(1213, '1111', '2015-07-21', 12, 3),
(1214, '1111', '2015-07-14', 4, 3),
(1215, '2323', '2015-07-28', 21, 3);

--
-- Índices para tablas volcadas
--

--
-- Indices de la tabla `detalle_venta`
--
ALTER TABLE `detalle_venta`
  ADD PRIMARY KEY (`ventas_codigo_ventas`,`producto_codigo_producto`), ADD KEY `fk_detalle_venta_producto1_idx` (`producto_codigo_producto`);

--
-- Indices de la tabla `perfil`
--
ALTER TABLE `perfil`
  ADD PRIMARY KEY (`codigo_perfil`);

--
-- Indices de la tabla `producto`
--
ALTER TABLE `producto`
  ADD PRIMARY KEY (`codigo_producto`,`tipo_codigo_tipo`), ADD KEY `fk_producto_tipo1_idx` (`tipo_codigo_tipo`);

--
-- Indices de la tabla `tipo`
--
ALTER TABLE `tipo`
  ADD PRIMARY KEY (`codigo_tipo`);

--
-- Indices de la tabla `usuarios`
--
ALTER TABLE `usuarios`
  ADD PRIMARY KEY (`id_usuario`,`perfil_codigo_perfil`), ADD KEY `fk_usuarios_perfil1_idx` (`perfil_codigo_perfil`);

--
-- Indices de la tabla `ventas`
--
ALTER TABLE `ventas`
  ADD PRIMARY KEY (`codigo_ventas`,`perfil_codigo_perfil`), ADD KEY `fk_ventas_perfil1_idx` (`perfil_codigo_perfil`);

--
-- AUTO_INCREMENT de las tablas volcadas
--

--
-- AUTO_INCREMENT de la tabla `detalle_venta`
--
ALTER TABLE `detalle_venta`
  MODIFY `ventas_codigo_ventas` int(11) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=1214;
--
-- AUTO_INCREMENT de la tabla `perfil`
--
ALTER TABLE `perfil`
  MODIFY `codigo_perfil` int(3) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=4;
--
-- AUTO_INCREMENT de la tabla `producto`
--
ALTER TABLE `producto`
  MODIFY `codigo_producto` int(11) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=521223;
--
-- AUTO_INCREMENT de la tabla `tipo`
--
ALTER TABLE `tipo`
  MODIFY `codigo_tipo` int(11) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=11;
--
-- AUTO_INCREMENT de la tabla `usuarios`
--
ALTER TABLE `usuarios`
  MODIFY `id_usuario` int(11) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=46;
--
-- AUTO_INCREMENT de la tabla `ventas`
--
ALTER TABLE `ventas`
  MODIFY `codigo_ventas` int(11) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=1216;
--
-- Restricciones para tablas volcadas
--

--
-- Filtros para la tabla `detalle_venta`
--
ALTER TABLE `detalle_venta`
ADD CONSTRAINT `fk_detalle_venta_producto1` FOREIGN KEY (`producto_codigo_producto`) REFERENCES `producto` (`codigo_producto`) ON DELETE NO ACTION ON UPDATE NO ACTION,
ADD CONSTRAINT `fk_detalle_venta_ventas1` FOREIGN KEY (`ventas_codigo_ventas`) REFERENCES `ventas` (`codigo_ventas`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Filtros para la tabla `producto`
--
ALTER TABLE `producto`
ADD CONSTRAINT `fk_producto_tipo1` FOREIGN KEY (`tipo_codigo_tipo`) REFERENCES `tipo` (`codigo_tipo`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Filtros para la tabla `usuarios`
--
ALTER TABLE `usuarios`
ADD CONSTRAINT `fk_usuarios_perfil1` FOREIGN KEY (`perfil_codigo_perfil`) REFERENCES `perfil` (`codigo_perfil`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Filtros para la tabla `ventas`
--
ALTER TABLE `ventas`
ADD CONSTRAINT `fk_ventas_perfil1` FOREIGN KEY (`perfil_codigo_perfil`) REFERENCES `perfil` (`codigo_perfil`) ON DELETE NO ACTION ON UPDATE NO ACTION;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
